import { BaseConnection, type SessionConfig, type FormatConfig } from "./BaseConnection";
import { type OutgoingSocketEvent } from "./events";
import { Room } from "livekit-client";
export type ConnectionConfig = SessionConfig & {
    onDebug?: (info: unknown) => void;
};
export declare class WebRTCConnection extends BaseConnection {
    conversationId: string;
    readonly inputFormat: FormatConfig;
    readonly outputFormat: FormatConfig;
    private room;
    private isConnected;
    private audioEventId;
    private audioCaptureContext;
    private audioElements;
    private outputDeviceId;
    private outputAnalyser;
    private outputFrequencyData;
    private constructor();
    static create(config: ConnectionConfig): Promise<WebRTCConnection>;
    private setupRoomEventListeners;
    close(): void;
    sendMessage(message: OutgoingSocketEvent): Promise<void>;
    getRoom(): Room;
    setMicMuted(isMuted: boolean): Promise<void>;
    private setupAudioCapture;
    setAudioVolume(volume: number): void;
    setAudioOutputDevice(deviceId: string): Promise<void>;
    setAudioInputDevice(deviceId: string): Promise<void>;
    getOutputByteFrequencyData(): Uint8Array<ArrayBuffer> | null;
}
